// Copyright ® 2025 OneSpan North America, Inc. All rights reserved. 

 
/////////////////////////////////////////////////////////////////////////////
//
//
// This file is example source code. It is provided for your information and
// assistance. See your licence agreement for details and the terms and
// conditions of the licence which governs the use of the source code. By using
// such source code you will be accepting these terms and conditions. If you do
// not wish to accept these terms and conditions, DO NOT OPEN THE FILE OR USE
// THE SOURCE CODE.
//
// Note that there is NO WARRANTY.
//
//////////////////////////////////////////////////////////////////////////////


/*
 * Copyright 2017 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.vasco.digipass.sdk.utils.qrcodescanner.sample

import android.content.Context
import android.content.Intent
import android.os.Build
import android.os.Bundle
import android.os.VibrationEffect
import android.os.Vibrator
import android.os.VibratorManager
import android.view.View
import android.view.ViewGroup.MarginLayoutParams
import android.view.Window
import androidx.annotation.RequiresApi
import androidx.appcompat.app.AppCompatActivity
import androidx.core.view.ViewCompat
import androidx.core.view.WindowInsetsCompat
import androidx.core.view.WindowInsetsControllerCompat
import com.vasco.digipass.sdk.utils.qrcodescanner.QRCodeScannerSDKConstants
import com.vasco.digipass.sdk.utils.qrcodescanner.sample.CameraFragment.Companion.newInstance
import com.vasco.digipass.sdk.utils.qrcodescanner.sample.CameraFragment.ImageDecoderListener

class SystemCameraActivity : AppCompatActivity(), ImageDecoderListener {
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_camera)

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.Q) {
            val rootView = findViewById<View>(R.id.fragment_container)
            setInsets(window, rootView)
        }

        if (null == savedInstanceState) {
            supportFragmentManager.beginTransaction()
                .replace(R.id.fragment_container, newInstance())
                .commit()
        }
    }

    @RequiresApi(api = Build.VERSION_CODES.Q)
    fun setInsets(window: Window, rootView: View) {
        val controller =
            WindowInsetsControllerCompat(window, window.decorView)
        controller.isAppearanceLightStatusBars = true
        ViewCompat.setOnApplyWindowInsetsListener(
            rootView
        ) { v, insets ->
            val systemBars = WindowInsetsCompat.Type.systemBars()
            val systemBarInsets = insets.getInsets(systemBars)

            val layoutParams = v.layoutParams as MarginLayoutParams
            layoutParams.topMargin = systemBarInsets.top
            layoutParams.bottomMargin = systemBarInsets.bottom
            layoutParams.leftMargin = systemBarInsets.left
            layoutParams.rightMargin = systemBarInsets.right

            v.layoutParams = layoutParams
            WindowInsetsCompat.CONSUMED
        }
    }

    override fun onBackPressed() {
        super.onBackPressed()
        onScanCancelled()
    }

    override fun onImageScanned(scannedImageFormat: Int, scannedImageData: String) {
        val vibrator = if (Build.VERSION.SDK_INT < Build.VERSION_CODES.S) {
            @Suppress("DEPRECATION")
            getSystemService(Context.VIBRATOR_SERVICE) as Vibrator
        } else {
            val vibratorManager = getSystemService(Context.VIBRATOR_MANAGER_SERVICE) as VibratorManager
            vibratorManager.defaultVibrator
        }

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            vibrator.vibrate(VibrationEffect.createOneShot(100, VibrationEffect.DEFAULT_AMPLITUDE))
        } else {
            @Suppress("DEPRECATION")
            vibrator.vibrate(100)
        }
        val intent = Intent()
        intent.putExtra(QRCodeScannerSDKConstants.OUTPUT_RESULT, scannedImageData)
        intent.putExtra(QRCodeScannerSDKConstants.OUTPUT_CODE_TYPE, scannedImageFormat)
        setResult(RESULT_OK, intent)
        finish()
    }

    override fun onExceptionThrown(e: Throwable) {
        val intent = Intent()
        intent.putExtra(QRCodeScannerSDKConstants.OUTPUT_EXCEPTION, e)
        setResult(QRCodeScannerSDKConstants.RESULT_ERROR, intent)
        finish()
    }

    private fun onScanCancelled() {
        setResult(RESULT_CANCELED)
        finish()
    }
}
